<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Admin Dashboard')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="//unpkg.com/alpinejs" defer></script>
</head>
<body class="flex h-screen bg-gray-100 font-sans">

    <!-- Sidebar -->
    <aside class="bg-gray-800 text-white w-64 flex-shrink-0 hidden md:flex flex-col">
        <div class="p-6 text-2xl font-bold border-b border-gray-700">
            Admin Panel
        </div>
        <nav class="flex-1 mt-4">
            <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="block py-3 px-6 hover:bg-gray-700 rounded">
                Dashboard
            </x-nav-link>
            <x-nav-link href="#" class="block py-3 px-6 hover:bg-gray-700 rounded">Orders</x-nav-link>
            <x-nav-link href="#" class="block py-3 px-6 hover:bg-gray-700 rounded">Products</x-nav-link>
            <x-nav-link href="#" class="block py-3 px-6 hover:bg-gray-700 rounded">Users</x-nav-link>
        </nav>
    </aside>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col overflow-hidden">
        <!-- Top Navbar -->
        <nav class="bg-white shadow px-4 py-4 flex justify-between items-center md:hidden">
            <span class="font-bold text-lg">Admin Panel</span>
            <div class="flex items-center space-x-4">
                <span>{{ Auth::user()->name }}</span>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="text-red-600 hover:text-red-800">Logout</button>
                </form>
            </div>
        </nav>

        <!-- Content -->
        <main class="flex-1 overflow-auto p-6">
            @yield('header')
            @yield('content')
        </main>
    </div>

</body>
</html>
