<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>অ্যাসেন্ড হুডি - সর্বোত্তম আরাম ও স্টাইল</title>
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-gradient-to-br from-gray-50 via-white to-indigo-50 text-gray-800 antialiased">

    <!-- স্টিকি হেডার -->
    <header class="sticky top-0 z-50 glass-effect shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
            <a href="#" class="text-3xl font-black tracking-tight gradient-text">অ্যাসেন্ড</a>
            <div class="flex items-center gap-6">
                <a href="#features"
                    class="hidden md:block text-gray-700 hover:text-indigo-600 font-medium transition">বৈশিষ্ট্য</a>
                <a href="#reviews"
                    class="hidden md:block text-gray-700 hover:text-indigo-600 font-medium transition">রিভিউ</a>
                <a href="#buy"
                    class="text-sm font-bold text-white bg-gradient-to-r from-indigo-600 to-purple-600 py-3 px-6 rounded-full hover:from-indigo-700 hover:to-purple-700 transition-all shadow-lg hover:shadow-xl transform hover:scale-105">এখনই
                    কিনুন</a>
            </div>
        </div>
    </header>

    <!-- হিরো সেকশন -->
    <section class="relative bg-gradient-to-br from-gray-900 via-indigo-900 to-purple-900 overflow-hidden" id="hero">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-10 left-10 w-72 h-72 bg-indigo-500 rounded-full filter blur-3xl animate-float">
            </div>
            <div class="absolute bottom-10 right-10 w-96 h-96 bg-purple-500 rounded-full filter blur-3xl animate-float"
                style="animation-delay: 2s;"></div>
        </div>

        <div
            class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-20 pb-28 lg:pt-28 lg:pb-36 grid lg:grid-cols-2 gap-16 items-center relative z-10">

            <div class="text-center lg:text-left animate-fadeInUp">
                <div
                    class="inline-block mb-4 px-4 py-2 bg-indigo-500/20 backdrop-blur-sm rounded-full border border-indigo-400/30">
                    <p class="text-sm font-semibold text-indigo-300 tracking-wide">✨ অসীম আরামের অভিজ্ঞতা</p>
                </div>
                <h1 class="text-5xl sm:text-6xl lg:text-7xl font-black tracking-tight text-white mb-6 leading-tight">
                    <span class="block">সর্বোচ্চ</span>
                    <span class="block gradient-text" style="-webkit-text-fill-color: #a78bfa;">গুণগত মান</span>
                    <span class="block text-indigo-300">অ্যাসেন্ড হুডি</span>
                </h1>
                <p class="mt-6 text-xl sm:text-2xl text-gray-300 max-w-xl mx-auto lg:mx-0 mb-10 leading-relaxed">
                    জৈব হেভিওয়েট ফ্লিস থেকে তৈরি। <span class="font-bold text-white">সরল নকশা</span> এবং <span
                        class="font-bold text-white">অবিস্মরণীয় টেকসইতায়</span> এর নিখুঁত সমন্বয়।
                </p>
                <div class="flex flex-col sm:flex-row justify-center lg:justify-start gap-4">
                    <a href="#buy"
                        class="cta-button bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-bold py-5 px-12 rounded-2xl text-xl uppercase tracking-wider inline-flex items-center justify-center gap-2">
                        আপনারটি পান <span class="text-2xl">→</span>
                    </a>
                    <a href="#features"
                        class="glass-effect text-white font-bold py-5 px-12 rounded-2xl text-xl uppercase tracking-wider inline-flex items-center justify-center hover:bg-white/20 transition-all">
                        আরও জানুন
                    </a>
                </div>

                <!-- বিশ্বাস সূচক -->
                <div class="flex justify-center lg:justify-start gap-8 mt-12 text-white">
                    <div>
                        <div class="text-3xl font-bold">১৫,০০০+</div>
                        <div class="text-indigo-300 text-sm">সন্তুষ্ট গ্রাহক</div>
                    </div>
                    <div>
                        <div class="text-3xl font-bold">৪.৯★</div>
                        <div class="text-indigo-300 text-sm">গড় রেটিং</div>
                    </div>
                    <div>
                        <div class="text-3xl font-bold">১০০%</div>
                        <div class="text-indigo-300 text-sm">প্রিমিয়াম মান</div>
                    </div>
                </div>
            </div>

            <div class="flex justify-center lg:justify-end animate-fadeInUp" style="animation-delay: 0.2s;">
                <div class="relative w-full max-w-lg">
                    <div
                        class="absolute inset-0 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-3xl blur-2xl opacity-30">
                    </div>
                    <div
                        class="relative aspect-[4/5] bg-gradient-to-br from-gray-800 to-gray-900 rounded-3xl shadow-2xl overflow-hidden ring-4 ring-indigo-500/30">
                        <img src="https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop"
                            alt="প্রিমিয়াম কালো হুডি"
                            class="w-full h-full object-cover transform hover:scale-105 transition-transform duration-700 ease-out">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- বৈশিষ্ট্য সেকশন -->
    <section class="py-24 sm:py-32 bg-white" id="features">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-20 animate-fadeInUp">
                <h2 class="text-5xl sm:text-6xl font-black text-gray-900 mb-6">আধুনিক জীবনের জন্য নকশা করা</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">প্রতিটি বিবরণ পরিপূর্ণতার জন্য তৈরি</p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div
                    class="feature-card text-center p-10 bg-gradient-to-br from-white to-indigo-50 rounded-3xl shadow-xl border border-indigo-100 hover:shadow-2xl">
                    <div
                        class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-indigo-500 to-purple-600 text-white text-4xl rounded-2xl mb-6 shadow-lg">
                        🧵</div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-900">হেভিওয়েট ফ্লিস</h3>
                    <p class="text-gray-600 leading-relaxed">৩৮০ জিএসএম জৈব সুতি উষ্ণতা নিশ্চিত করে এবং একটি বিলাসবহুল,
                        দীর্ঘস্থায়ী বুনন যা বছরের পর বছর টিকে থাকে।</p>
                </div>

                <div
                    class="feature-card text-center p-10 bg-gradient-to-br from-white to-green-50 rounded-3xl shadow-xl border border-green-100 hover:shadow-2xl">
                    <div
                        class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-green-500 to-emerald-600 text-white text-4xl rounded-2xl mb-6 shadow-lg">
                        🌱</div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-900">টেকসই সোর্সিং</h3>
                    <p class="text-gray-600 leading-relaxed">জিওটিএস-সার্টিফাইড উপকরণ দিয়ে দায়িত্বশীলভাবে তৈরি। আপনার
                        জন্য ভালো, পৃথিবীর জন্য আরও ভালো।</p>
                </div>

                <div
                    class="feature-card text-center p-10 bg-gradient-to-br from-white to-amber-50 rounded-3xl shadow-xl border border-amber-100 hover:shadow-2xl">
                    <div
                        class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-amber-500 to-orange-600 text-white text-4xl rounded-2xl mb-6 shadow-lg">
                        🔒</div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-900">দীর্ঘস্থায়ী নির্মাণ</h3>
                    <p class="text-gray-600 leading-relaxed">শক্তিশালী সেলাই মানে এই হুডিটি আপনার ওয়ারড্রবের একটি প্রধান
                        অংশ হবে বহু বছর ধরে।</p>
                </div>
            </div>
        </div>
    </section>

    <!-- পণ্য সেকশন -->
    <section class="py-24 sm:py-32 bg-gradient-to-b from-gray-50 to-white" id="buy">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 grid lg:grid-cols-2 gap-16 items-start">

            <!-- ইমেজ গ্যালারি -->
            <div class="space-y-6 image-gallery">
                <div
                    class="relative w-full bg-gradient-to-br from-gray-100 to-gray-200 rounded-3xl shadow-2xl aspect-[4/3] overflow-hidden ring-4 ring-indigo-100">
                    <img id="mainProductImage"
                        src="https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop"
                        alt="মূল হুডি ভিউ" class="w-full h-full object-cover">
                    <div
                        class="absolute top-4 right-4 bg-gradient-to-r from-indigo-600 to-purple-600 text-white px-4 py-2 rounded-full text-sm font-bold shadow-lg">
                        সীমিত স্টক
                    </div>
                </div>

                <div class="grid grid-cols-4 gap-4">
                    <img onclick="changeMainImage(this.src)"
                        src="https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop"
                        alt="ভিউ ১"
                        class="aspect-square bg-gray-200 rounded-2xl cursor-pointer ring-4 ring-indigo-500 object-cover hover:ring-indigo-600">
                    <img onclick="changeMainImage(this.src)"
                        src="https://images.unsplash.com/photo-1620799140408-edc6dcb6d633?w=800&h=1000&fit=crop"
                        alt="ভিউ ২"
                        class="aspect-square bg-gray-200 rounded-2xl cursor-pointer ring-4 ring-transparent hover:ring-gray-300 object-cover">
                    <img onclick="changeMainImage(this.src)"
                        src="https://images.unsplash.com/photo-1620012253295-c15cc3e65df4?w=800&h=1000&fit=crop"
                        alt="ভিউ ৩"
                        class="aspect-square bg-gray-200 rounded-2xl cursor-pointer ring-4 ring-transparent hover:ring-gray-300 object-cover">
                    <img onclick="changeMainImage(this.src)"
                        src="https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop"
                        alt="ভিউ ৪"
                        class="aspect-square bg-gray-200 rounded-2xl cursor-pointer ring-4 ring-transparent hover:ring-gray-300 object-cover">
                </div>
            </div>

            <!-- পণ্যের বিবরণ -->
            <div class="lg:sticky lg:top-24">
                <div class="inline-block mb-4 px-4 py-2 bg-green-100 rounded-full">
                    <p class="text-sm font-bold text-green-700">✓ স্টকে আছে - সীমিত পরিমাণ</p>
                </div>

                <h2 class="text-5xl font-black text-gray-900 mb-3">ক্লাসিক পুলওভার</h2>
                <div class="flex items-center gap-3 mb-6">
                    <div class="flex text-yellow-400 text-xl">★★★★★</div>
                    <span class="text-gray-600 font-medium">৪.৯ (২,৪৫১ রিভিউ)</span>
                </div>

                <div class="flex items-baseline gap-4 mb-8">
                    <p
                        class="text-6xl font-black bg-gradient-to-r from-indigo-600 to-purple-600 bg-clip-text text-transparent">
                        ৳৮৯</p>
                    <span class="text-3xl text-gray-400 line-through">৳১২৯</span>
                    <span class="bg-red-500 text-white px-3 py-1 rounded-full text-sm font-bold">৩১% সেভ করুন</span>
                </div>

                <!-- রঙ নির্বাচন -->
                <div class="mb-8">
                    <h3 class="text-lg font-bold text-gray-900 uppercase tracking-wider mb-4">রঙ: <span
                            class="gradient-text">অবসিডিয়ান কালো</span></h3>
                    <div class="flex gap-4">
                        <button
                            onclick="selectColor('black', 'https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop')"
                            id="color-black" class="color-option active w-14 h-14 rounded-full bg-gray-900 shadow-lg"
                            aria-label="কালো"></button>
                        <button
                            onclick="selectColor('gray', 'https://images.unsplash.com/photo-1620799140408-edc6dcb6d633?w=800&h=1000&fit=crop')"
                            id="color-gray" class="color-option w-14 h-14 rounded-full bg-gray-400 shadow-lg"
                            aria-label="ধূসর"></button>
                        <button
                            onclick="selectColor('navy', 'https://images.unsplash.com/photo-1556821840-3a63f95609a7?w=800&h=1000&fit=crop')"
                            id="color-navy" class="color-option w-14 h-14 rounded-full bg-blue-900 shadow-lg"
                            aria-label="নেভি"></button>
                        <button
                            onclick="selectColor('olive', 'https://images.unsplash.com/photo-1620799140408-edc6dcb6d633?w=800&h=1000&fit=crop')"
                            id="color-olive" class="color-option w-14 h-14 rounded-full bg-green-800 shadow-lg"
                            aria-label="অলিভ"></button>
                    </div>
                </div>

                <!-- সাইজ নির্বাচন -->
                <div class="mb-10">
                    <h3 class="text-lg font-bold text-gray-900 uppercase tracking-wider mb-4">সাইজ: <span
                            class="gradient-text">এল</span></h3>
                    <div class="grid grid-cols-4 gap-3">
                        <button onclick="selectSize('S')" id="size-S"
                            class="size-option p-4 text-center border-3 border-gray-200 text-gray-700 font-bold rounded-xl hover:border-indigo-600 hover:bg-indigo-50 transition-all">এস</button>
                        <button onclick="selectSize('M')" id="size-M"
                            class="size-option p-4 text-center border-3 border-gray-200 text-gray-700 font-bold rounded-xl hover:border-indigo-600 hover:bg-indigo-50 transition-all">এম</button>
                        <button onclick="selectSize('L')" id="size-L"
                            class="size-option p-4 text-center border-3 border-indigo-600 bg-gradient-to-br from-indigo-50 to-purple-50 text-indigo-600 font-bold rounded-xl shadow-lg">এল</button>
                        <button onclick="selectSize('XL')" id="size-XL"
                            class="size-option p-4 text-center border-3 border-gray-200 text-gray-700 font-bold rounded-xl hover:border-indigo-600 hover:bg-indigo-50 transition-all">এক্সএল</button>
                    </div>
                    <a href="#"
                        class="mt-4 text-sm text-indigo-600 hover:text-indigo-800 transition-all inline-block font-bold underline">📏
                        সাইজ গাইড</a>
                </div>

                <!-- কিনুন বাটন -->
                <button
                    class="cta-button w-full bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-black py-6 rounded-2xl shadow-2xl text-2xl uppercase tracking-wider mb-6">
                    কার্টে যোগ করুন - ৳৮৯
                </button>

                <!-- বিশ্বাস ব্যাজ -->
                <div
                    class="grid grid-cols-3 gap-4 p-6 bg-gradient-to-r from-indigo-50 to-purple-50 rounded-2xl border-2 border-indigo-100">
                    <div class="text-center">
                        <div class="text-2xl mb-1">🚚</div>
                        <div class="font-bold text-gray-900 text-sm">বিনামূল্যে ডেলিভারি</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl mb-1">🔒</div>
                        <div class="font-bold text-gray-900 text-sm">সুরক্ষিত পেমেন্ট</div>
                    </div>
                    <div class="text-center">
                        <div class="text-2xl mb-1">🔄</div>
                        <div class="font-bold text-gray-900 text-sm">৩০ দিন রিটার্ন</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- রিভিউ সেকশন -->
    <section class="py-24 sm:py-32 bg-gradient-to-b from-indigo-50 to-white" id="reviews">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-20">
                <h2 class="text-5xl sm:text-6xl font-black text-gray-900 mb-6">আমাদের গ্রাহকরা কী বলেন</h2>
                <div class="flex justify-center items-center gap-3">
                    <div class="flex text-yellow-400 text-3xl">★★★★★</div>
                    <span class="text-2xl text-gray-600 font-bold">২,৪৫১ রিভিউ থেকে ৪.৯/৫</span>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="review-card bg-white p-10 rounded-3xl shadow-xl border-l-4 border-indigo-500 hover:shadow-2xl">
                    <div class="flex text-yellow-400 mb-4 text-2xl">★★★★★</div>
                    <blockquote class="italic text-gray-700 mb-6 text-lg leading-relaxed">"অবিশ্বাস্য মান! ওজনটি নিখুঁত এবং
                        ফিটটি আশ্চর্যজনক। এটি দীর্ঘস্থায়ী পণ্যের জন্য সেরা বিনিয়োগ।"</blockquote>
                    <div class="flex items-center gap-4">
                        <div
                            class="w-14 h-14 bg-gradient-to-br from-indigo-400 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            এআর</div>
                        <div>
                            <p class="font-bold text-gray-900 text-lg">আপু রায়</p>
                            <p class="text-sm text-gray-600">যাচাইকৃত ক্রেতা</p>
                        </div>
                    </div>
                </div>

                <div class="review-card bg-white p-10 rounded-3xl shadow-xl border-l-4 border-purple-500 hover:shadow-2xl">
                    <div class="flex text-yellow-400 mb-4 text-2xl">★★★★★</div>
                    <blockquote class="italic text-gray-700 mb-6 text-lg leading-relaxed">"অবশেষে একটি প্রিমিয়াম হুডি
                        পাওয়া গেল যা পাতলা নয়! আমি ধূসর রঙটি কিনেছি এবং এখন কালো রঙটিও কিনছি।"</blockquote>
                    <div class="flex items-center gap-4">
                        <div
                            class="w-14 h-14 bg-gradient-to-br from-purple-400 to-pink-600 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            এনএস</div>
                        <div>
                            <p class="font-bold text-gray-900 text-lg">নাদিয়া সুলতানা</p>
                            <p class="text-sm text-gray-600">যাচাইকৃত ক্রেতা</p>
                        </div>
                    </div>
                </div>

                <div class="review-card bg-white p-10 rounded-3xl shadow-xl border-l-4 border-green-500 hover:shadow-2xl">
                    <div class="flex text-yellow-400 mb-4 text-2xl">★★★★★</div>
                    <blockquote class="italic text-gray-700 mb-6 text-lg leading-relaxed">"দ্রুত ডেলিভারি এবং কাপড়টি
                        অবিশ্বাস্যভাবে নরম। এটি ভ্রমণ এবং বিশ্রামের জন্য আমার নতুন প্রিয় পোশাক। ধন্যবাদ অ্যাসেন্ড!"</blockquote>
                    <div class="flex items-center gap-4">
                        <div
                            class="w-14 h-14 bg-gradient-to-br from-green-400 to-emerald-600 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            জেডএইচ</div>
                        <div>
                            <p class="font-bold text-gray-900 text-lg">জাহিদ হাসান</p>
                            <p class="text-sm text-gray-600">যাচাইকৃত ক্রেতা</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- চূড়ান্ত কল টু অ্যাকশন -->
    <section class="py-28 bg-gradient-to-br from-gray-900 via-indigo-900 to-purple-900 relative overflow-hidden"
        id="final-cta">
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-0 left-0 w-96 h-96 bg-indigo-500 rounded-full filter blur-3xl animate-float">
            </div>
            <div class="absolute bottom-0 right-0 w-96 h-96 bg-purple-500 rounded-full filter blur-3xl animate-float"
                style="animation-delay: 2s;"></div>
        </div>

        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
            <h2 class="text-4xl sm:text-6xl font-black text-white mb-6 leading-tight">
                আজই আপনার কালেকশন আপগ্রেড করুন
            </h2>
            <p class="text-xl sm:text-2xl text-indigo-200 mb-12 max-w-3xl mx-auto leading-relaxed">
                সীমিত স্টক উপলব্ধ। আরাম এবং স্টাইলের উপর আপোষ করবেন না।
            </p>
            <a href="#buy"
                class="cta-button inline-block bg-white text-indigo-900 font-black py-6 px-16 rounded-2xl text-2xl uppercase tracking-wider shadow-2xl hover:bg-gray-100">
                কালেকশন কিনুন এখনই →
            </a>
            <div class="mt-10 flex flex-wrap justify-center gap-8 text-indigo-200">
                <span class="flex items-center gap-2"><span class="text-2xl">✓</span> বিনামূল্যে ডেলিভারি</span>
                <span class="flex items-center gap-2"><span class="text-2xl">✓</span> ৩০ দিন রিটার্ন</span>
                <span class="flex items-center gap-2"><span class="text-2xl">✓</span> সুরক্ষিত চেকআউট</span>
            </div>
        </div>
    </section>

    <!-- ফুটার -->
    <footer class="py-16 bg-gray-50 border-t border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-4 gap-8 mb-12">
                <!-- ব্র্যান্ড কলাম -->
                <div class="md:col-span-1">
                    <div class="text-3xl font-black gradient-text mb-4">অ্যাসেন্ড</div>
                    <p class="text-gray-600 mb-4">প্রতিদিনের জীবনযাপনের জন্য প্রিমিয়াম আরাম। যত্ন সহকারে তৈরি, দীর্ঘস্থায়ী
                        হওয়ার জন্য নির্মিত।</p>
                    <div class="flex space-x-4 mt-6">
                        <a href="#"
                            class="w-10 h-10 bg-indigo-100 rounded-full flex items-center justify-center text-indigo-600 hover:bg-indigo-600 hover:text-white transition">
                            <span class="text-lg">→</span>
                        </a>
                        <a href="#"
                            class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-600 hover:bg-gray-800 hover:text-white transition">
                            <span class="text-lg">★</span>
                        </a>
                        <a href="#"
                            class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-600 hover:bg-gray-800 hover:text-white transition">
                            <span class="text-lg">✉</span>
                        </a>
                    </div>
                </div>

                <!-- শপ কলাম -->
                <div>
                    <h4 class="font-bold text-gray-900 mb-4 text-lg uppercase tracking-wider">শপ</h4>
                    <div class="space-y-3">
                        <a href="#buy"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">হুডিস</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">নতুন
                            আগমন</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">সেরা বিক্রিত
                            পণ্য</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">সীমিত
                            সংস্করণ</a>
                    </div>
                </div>

                <!-- সাপোর্ট কলাম -->
                <div>
                    <h4 class="font-bold text-gray-900 mb-4 text-lg uppercase tracking-wider">সহায়তা</h4>
                    <div class="space-y-3">
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">যোগাযোগ
                            করুন</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">ডেলিভারি তথ্য</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">রিটার্ন ও
                            এক্সচেঞ্জ</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">সাইজ গাইড</a>
                    </div>
                </div>

                <!-- কোম্পানি কলাম -->
                <div>
                    <h4 class="font-bold text-gray-900 mb-4 text-lg uppercase tracking-wider">কোম্পানি</h4>
                    <div class="space-y-3">
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">আমাদের
                            সম্পর্কে</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">টেকসইতা</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">ক্যারিয়ার</a>
                        <a href="#"
                            class="block text-gray-600 hover:text-indigo-600 transition hover:translate-x-2">প্রেস</a>
                    </div>
                </div>
            </div>

            <!-- নিউজলেটার সাইনআপ -->
            <div class="bg-gradient-to-r from-indigo-50 to-purple-50 p-8 rounded-2xl mb-12 border border-indigo-100">
                <div class="max-w-md mx-auto text-center">
                    <h4 class="text-2xl font-bold text-gray-900 mb-3">অ্যাসেন্ড কমিউনিটিতে যোগ দিন</h4>
                    <p class="text-gray-600 mb-6">এক্সক্লুসিভ অফার, স্টাইলিং টিপস এবং নতুন ড্রপের প্রাথমিক অ্যাক্সেস পান।
                    </p>
                    <div class="flex flex-col sm:flex-row gap-3 max-w-md mx-auto">
                        <input type="email" placeholder="আপনার ইমেইল ঠিকানা"
                            class="flex-1 px-6 py-4 rounded-xl border border-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent">
                        <button
                            class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white font-bold py-4 px-8 rounded-xl hover:from-indigo-700 hover:to-purple-700 transition-all shadow-lg">
                            সাবস্ক্রাইব করুন
                        </button>
                    </div>
                </div>
            </div>

            <!-- নিচের বার -->
            <div class="pt-8 border-t border-gray-300">
                <div class="flex flex-col md:flex-row justify-between items-center gap-6">
                    <div class="text-gray-600">
                        <p class="font-medium">© ২০২৫ অ্যাসেন্ড অ্যাপারেল। সর্বস্বত্ব সংরক্ষিত।</p>
                    </div>
                    <div class="flex flex-wrap justify-center gap-6">
                        <a href="#" class="text-gray-600 hover:text-indigo-600 transition font-medium">গোপনীয়তা
                            নীতি</a>
                        <a href="#" class="text-gray-600 hover:text-indigo-600 transition font-medium">সেবার
                            শর্তাবলী</a>
                        <a href="#" class="text-gray-600 hover:text-indigo-600 transition font-medium">কুকি নীতি</a>
                        <a href="#" class="text-gray-600 hover:text-indigo-600 transition font-medium">প্রবেশযোগ্যতা</a>
                    </div>
                    <div class="flex items-center gap-4">
                        <span class="text-gray-600 text-sm">গ্রহণযোগ্য পেমেন্ট:</span>
                        <div class="flex gap-2">
                            <span class="w-10 h-6 bg-gray-200 rounded"></span>
                            <span class="w-10 h-6 bg-gray-200 rounded"></span>
                            <span class="w-10 h-6 bg-gray-200 rounded"></span>
                            <span class="w-10 h-6 bg-gray-200 rounded"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script>
        function changeMainImage(src) {
            const mainImg = document.getElementById('mainProductImage');
            mainImg.style.opacity = '0';
            setTimeout(() => {
                mainImg.src = src;
                mainImg.style.opacity = '1';
            }, 200);

            document.querySelectorAll('.image-gallery img').forEach(img => {
                img.classList.remove('ring-indigo-500');
                img.classList.add('ring-transparent');
            });
            event.target.classList.add('ring-indigo-500');
            event.target.classList.remove('ring-transparent');
        }

        function selectColor(color, imageUrl) {
            document.querySelectorAll('.color-option').forEach(el => el.classList.remove('active'));
            document.getElementById('color-' + color).classList.add('active');
            changeMainImage(imageUrl);
        }

        function selectSize(size) {
            document.querySelectorAll('.size-option').forEach(el => {
                el.classList.remove('border-indigo-600', 'bg-gradient-to-br', 'from-indigo-50', 'to-purple-50', 'text-indigo-600', 'shadow-lg');
                el.classList.add('border-gray-200', 'text-gray-700');
            });
            const sizeEl = document.getElementById('size-' + size);
            sizeEl.classList.remove('border-gray-200', 'text-gray-700');
            sizeEl.classList.add('border-indigo-600', 'bg-gradient-to-br', 'from-indigo-50', 'to-purple-50', 'text-indigo-600', 'shadow-lg');
        }

        // Smooth scroll animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -100px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        document.querySelectorAll('section').forEach(section => {
            if (!section.id.includes('hero')) {
                section.style.opacity = '0';
                section.style.transform = 'translateY(30px)';
                section.style.transition = 'all 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275)';
                observer.observe(section);
            }
        });
    </script>
</body>
</html>
<?php /**PATH /media/mahamodulhasan/Projects/BrainicsoftDigital/products/landing-laravel/sales-funnel/resources/views/home.blade.php ENDPATH**/ ?>